#include <bits/stdc++.h>

using namespace std;

vector<int> boje;
vector<bool> checked;

void dfs_group(vector<int> adj[], int s, int e) {
    for (auto u : adj[s]) {
        if (u != e && boje[u] == boje[s]) {
            checked[u] = true;
            dfs_group(adj, u, s);
        }
    }
}

int solve(vector<int> adj[], int n) {
    int res = 0;

    for (int i = 0; i < n; ++i) {
        if (!checked[i]) {
            ++res;
            dfs_group(adj, i, 0);
        }
    }

    return res;
}

void dfs_mod(vector<int> adj[], int s, int e) {
    for (auto u : adj[s]) {
        if (u != e) {
            boje[u] = boje[s];
            dfs_mod(adj, u, s);
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL); cout.tie(NULL);

    int n, q, u, v, c;

    cin >> n >> q;

    vector<int> adj[n];
    boje.resize(n, 0);
    checked.resize(n, 0);

    for (int i = 0; i < n - 1; ++i) {
        cin >> u >> v;
        --u, --v;

        adj[u].emplace_back(v);
    }

    for (int i = 0; i < n; ++i) {
        cin >> boje[i];
    }
    
    for (int i = 0; i < q; ++i) {
        cin >> u >> c;
        --u;

        boje[u] = c;
        dfs_mod(adj, u, 0);

        cout << solve(adj, n) << "\n";

        fill(checked.begin(), checked.end(), 0);
    }
}